/* ============ */
/* cntruns.c	*/
/* ============ */
#include <rundefs.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
/* ==================================================================== */
/* CountRuns - Counts runs in RandArray 				*/
/* ==================================================================== */
void
CountRuns(RUN_DATA_STRU *RunData)
{
    long    DtaIdx = -1;

    memset(RunData->RunCtrs, 0, sizeof(RunData->RunCtrs));

    while (DtaIdx < (long) RunData->ActRandCount - 1)
    {
	long	RunCtr = 0;

	do
	{
	    ++RunCtr;
	    ++DtaIdx;

	    if (DtaIdx >= (long) RunData->ActRandCount)
	    {
		break;
	    }
	}
	while (RunData->RandArray[DtaIdx] < RunData->RandArray[DtaIdx + 1]);

	if (RunCtr > 6)
	{
	    RunCtr = 6;
	}

	++RunData->RunCtrs[0];
	++RunData->RunCtrs[RunCtr];

	/* ---------------------------- */
	/* Throw away the element that	*/
	/* immediately follows a run.	*/
	/* ---------------------------- */
	++DtaIdx;

	if (DtaIdx >= (long) RunData->ActRandCount-1)
	{
	    if (DtaIdx == (long) RunData->ActRandCount-1)
	    {
		++RunData->RunCtrs[0];
		++RunData->RunCtrs[1];
	    }
	    break;
	}
    }					/* end while */

    RunData->CallStatus = TRUE;
}
